<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InRequest extends Model 
{

    protected $table = 'in_requests';
    public $timestamps = true;
    protected $fillable = array('nokia_requester_id', 'user_id', 'stream_id', 'notes', 'site_id', 'subcontractor_id', 'internal_supplier_id', 'work_order_id', 'delivery_id');

    public function nokia_requester()
    {
        return $this->belongsTo('App\Models\NokiaRequester');
    }

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function stream()
    {
        return $this->belongsTo('App\Models\Stream');
    }

    public function site()
    {
        return $this->belongsTo('App\Models\Site');
    }

    public function internal_supplier()
    {
        return $this->belongsTo('App\Models\InternalSupplier');
    }

    public function items()
    {
        return $this->morphToMany('App\Models\Item', 'itemable');
    }

    public function entity()
    {
        return $this->belongsTo('App\Models\Entity');
    }

    public function subcontractor()
    {
        return $this->belongsTo('App\Models\Subcontractor');
    }

    public function delivery()
    {
        return $this->belongsTo('App\User');
    }

}